--  Tasks:
-- restore_health -       
-- time_tick -   .    ,     
-- sleeping -     , 0 -   
--  Params: -   ,    
require( "scripts/game/deftasks.lua" );
require( "scripts/game/deftime.lua" );
-- class tomato
GameObject = {
--  
    Params = {
        ID="pumpkins";  -- do not change this parameter
        width=3;   -- do not change this parameter
        height=1;  -- do not change this parameter
        health=5000;  -- 
        hungry=4500;  -- 
        thirst=4000;  -- 
        create_product = 10;  --   ()
        product_name = "pumpkin"; -- do not change this parameter
        speed=1;    -- ,    
        emotion=4;    -- do not change this parameter
        --first_delay_desire = { 5, 6 };  --    ,  .
        Impatience = 60; -- ammount of health that dissapers each second
        RandomTasks=3;
        AngerType=1;
        group=3;
        GridData= { 1, 1, 1 };   -- do not change this parameter
        --start_with_hearts = 4;   --    - 
    };
    -- list of all tasks for an object
    Tasks = 
    {
        watering = { FuncName="WateringTaskExecute",      index=0,  sleeping={5,6},   time_tick=1000,  skill_up = 0, restore_health=1000 };
        tools = { FuncName="FertilizingTaskExecute",index=3,  sleeping={5,6},   time_tick=1000,  skill_up = 0, restore_health=1000 };
        weeding = { FuncName="WeedingTaskExecute",        index=1,  sleeping={5,6},   time_tick=1000,  skill_up = 0, restore_health=1000, not_need_action=1 };
        collection= { FuncName="CollectionTaskExecute",   index=2,  sleeping={5,6},   time_tick=1000,  skill_up = 0, restore_health=0, final_cycle=1, not_need_action=1  };
    };
--       
    ActivePoints = { 
        watering = { 
                   { {}, 1,-1,0,  0,  1,-1,0 };
                   }; 
        weeding = { 
                   { {}, 1,-1,0,  0,  1,-1,0 };
                   }; 
        collection = { 
                   { {}, 1,-1,0,   0,  1, -1,0  };
                   };
        tools = {
                   { {}, 1,-1,0,   0,  1, -1,0  };
                   };
        take   = { 
                   { {"pumpkin"}, 4,0,0, 0,  4,0,0 };
                   { {"crow1"}, 2,0,0,  0,  0,0,0 };
                  };
    };
    Objects = {
        pumpkin = {};
    };
    -- list of all triggers for an object
    Triggers = {
        Anger = {FuncName="AngerTriger", NotRunWhen={"watering","weeding","collection","tools"}, was_run=0 }
    };
    --tasks to be performed after an object is created
    InitActiveTasks = {};   -- InitActiveTasks = {"eating"};
    --tasks an object is waiting ofr after it is created
    InitExpectedTasks = {};
    -- RandomTasks=3     
    Cycle = {
        index=0;
        index_sleep=0;
        max_index = 0;
    };
};
--   ,   
life_cycle = {
    { "watering", 15 };
    { "weeding", 10 };
    { "tools", 10 };
    { "collection", 10 };
};

function GameObject:Get()
    return self;
end

--        
function OnInit()
    OnInitHealth();
end

    
function isMayByTask(aTask)
    aObj = GameObject:Get(); 
    --if (aTask=="collection")then
    --    if((aObj.Params.health / aObj.Params.MaxHealth)<0.75)then
    --        return 0;
    --    end;
    --end;    
    return 1;   
end

function OnNextTask(aPrevTask, aNextTask)
--    if (aNextTask=="milking") then        
--        CPP_SetVisPrefix("_f");
--    end;
end

function GetParams()
    aObj = GameObject:Get();   
    return aObj.Params;
end

-- perform Task Weeding over external object and return true if task is completed
function WeedingTaskExecute()
    aObject = GameObject:Get();
    CPP_SetVisPrefix("_f");
    CPP_SetAnimState("left_stand_f");
    SleepAfterTaskCycle();
    --SleepAfterTask(aObject.Tasks.weeding);       
    aObject.Params.hungry = 5000;
    return 0;
end

-- perform Task ollection over external object and return true if task is completed
function CollectionTaskExecute()
    aObject = GameObject:Get(); 
    --CPP_CreateProduct(aObject.Params.product_name,GetProductCreate());
    local koof = aObject.Params.health / aObject.Params.MaxHealth;
    local count = aObject.Params.create_product * koof + 1;
    if(count > aObject.Params.create_product)then
        count = aObject.Params.create_product;
    end
    
    CPP_SetVisPrefix("");   
    CPP_SetAnimState("left_stand");
    SleepAfterTaskCycle();
    CPP_ChildObjAnimState("pumpkin","pumpkin",3,1,count);
    return 0;
end

-- perform Task WATERING  over external object and return true if task is completed
function WateringTaskExecute()
    aObject = GameObject:Get();
    CPP_SetVisPrefix("_f");
    CPP_SetAnimState("left_stand_f");
    aObject.Params.thirst = 5000;
    --SleepAfterTask(aObject.Tasks.watering);     
    SleepAfterTaskCycle();
    aObject.Triggers.Anger.was_run = 0;
    return 0;
end

function AngerTriger()
    aObj = GameObject:Get();
    aObj.Params.health = aObj.Params.health - aObj.Params.Impatience;    
    if(aObj.Params.health<0) then aObj.Params.health = 0; end
    CPP_OnHealthChanged(aObj.Params.health);
    if(  aObj.Params.health / aObj.Params.MaxHealth<0.25)then
        if (aObj.Triggers.Anger.was_run == 0) then
            if (CPP_BreakExpectedTask("collection") > 0) then
                CPP_SetAnimState("anger_collection_f");
                --CPP_WantSelect(1);
                aObj.Triggers.Anger.was_run = 1;
            end
        end
    end
end
--
function FertilizingTaskExecute()
    aObject = GameObject:Get();
    CPP_SetVisPrefix("_f");
    CPP_SetAnimState("left_stand_f");
    SleepAfterTaskCycle();
    aObject.Triggers.Anger.was_run = 0;
    return 0;
end
